use POSIX qw(ceil floor);

open F, "podkatzer.log" or die "<html><body><h1>Error</h1>podkatzer.log not found!</body></html>";

print '
<html>
<head>
<style type="text/css">
body {
  font-family:Helvetica,Arial,sans-serif;
  font-size:14px;
  background-color:#303030;
  color:white;
  font-weight:bold;
}

h2 { 
  color:lightblue; 
  font-size:14px; 
}

table {
  border:1px solid white;
}

th {
  color:grey;
  font-size:12px;
  font-weight:bold;
  border-bottom:1px solid white;
}

td {
  font-size:10px;
  padding-right:10px;
}
</style>
</head>
<body>
';

foreach $line (<F>){
	chomp $line;
	if ($line =~ /^#CLEANSTART (.*)$/){
		print "<h2>$1</h2>\n";
		print "<table><tr><th>FeedName</th><th>FileName</th><th>Age (d)</th></tr>\n";
	} elsif ($line =~ /^#CLEANPODCAST (.*)$/){
		my ($feedName, $fileName, $fileDate) = split /\t/, $1;
		$fileDate = floor($fileDate*10)/10;
		print "<tr><td>$feedName</td><td>$fileName</td><td>$fileDate</td></tr>\n";
	} elsif ($line =~ /^#CLEANDONE (.*)$/){
		print "</table>\n";
		print "$1\n\n";
	} elsif ($line =~ /^#FEEDSTART (.*)$/){
		print "<h2>$1</h2>\n";
#		print "<table><tr><th>FeedName</th></tr>\n";
#	} elsif ($line =~ /^#FEEDGET (.*)$/){
#		print "<tr><td>$1</td></tr>\n";
	} elsif ($line =~ /^#FEEDDONE (.*)$/){
#		print "</table>\n";
		print "$1\n\n";
	} elsif ($line =~ /^#FETCHSTART (.*)$/){
		print "<h2>$1</h2>\n";
		print "<table>";
		print "<tr>";
		print "<th>FeedName</th>";
		print "<th>FileName</th>";
		print "<th>Size (MB)</th>";
		print "<th>Publication Date</th>";
#		print "<th>Enclosure URL</th>";
		print "</tr>\n";
	} elsif ($line =~ /^#PODCAST (.*)$/){
		my ($feedName, $contentFile, $size, $pubDate, $enclosureUrl) = split /\t/, $1;
		$sizeMB = $size / 1024 / 1024;
		$sizeMB = floor($sizeMB*10)/10;
		print "<tr>";
		print "<td>$feedName</td>";
		print "<td>$contentFile</td>";
		print "<td>$sizeMB</td>";
		print "<td>$pubDate</td>";
#		print "<td>$enclosureUrl</td>";
		print "</tr>\n";
	} elsif ($line =~ /^ \*\*\* WARNUNG\: (.*)$/){
		print '<tr><td colspan="5"><font color="red"><b>'.$1.'</b></font></td></tr>';
	} elsif ($line =~ /^#FETCHDONE (.*)$/){
		print "</table>\n";
		print "$1\n\n";
	}



}

close F;

