use strict;
use Tk;

my $eventpad;

my $mw = MainWindow->new;
# Mainwindow: sizex/y, positionx/y
$mw->geometry("450x120+100+120");
&create_widgets;


sub create_widgets {
	# the "eventpad" is a "Text"-widget which has a scrollbar.
	# The "Scrolled"-method does everything I need for scrolling
	$eventpad = $mw->Scrolled(
		# Which kind of widget? A "ROText"-widget
		# RO = Read Only
		'ROText',
		# scrollbar on the right
		-scrollbars => 'e',
		# width/height in characters
		-width => 40,
		-height => 15,
		)->pack(-side => 'left', -padx => 10);

	# Ok-Button
	my $ok_button = $mw->Button(
		-text => 'Do something',
		-command => sub { 
			$eventpad->insert( 
				# put something to the _end_ of the text
				# which is in the widget
				'end', 
				sprintf("%s - yadda, yadda\n", scalar localtime)
			);
			# Set window to the end of the text
			# I want to see the newest events immediately
			$eventpad->see('end');
		}
	)->pack(-side => 'right', -padx => 20);

	MainLoop;
}